<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('moduls', function (Blueprint $table) {
            $table->id();
            $table->string('kode');
            $table->string('judul');
            $table->text('isi');
            $table->text('link');
            $table->text('gambar');
            $table->enum('status', ['Y', 'N']);
            $table->dateTime('tgl1')->nullable();
            $table->dateTime('tgl2')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('moduls');
    }
};
